/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client;

import blusunrize.immersiveengineering.common.util.sound.IEBlockEntitySound;
import blusunrize.immersiveengineering.mixin.accessors.client.FontResourceManagerAccess;
import blusunrize.immersiveengineering.mixin.accessors.client.MinecraftAccess;
import com.google.common.base.Preconditions;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.mojang.math.Quaternion;
import com.mojang.math.Transformation;
import com.mojang.math.Vector4f;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.font.FontManager;
import net.minecraft.client.gui.font.FontSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.compress.utils.IOUtils;

public class ClientUtils {
    private static Font unicodeRenderer;

    public static Minecraft mc() {
        return Minecraft.m_91087_();
    }

    public static void bindTexture(ResourceLocation texture) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
    }

    public static TextureAtlasSprite getSprite(ResourceLocation rl) {
        return ClientUtils.mc().m_91304_().m_119428_(InventoryMenu.f_39692_).m_118316_(rl);
    }

    public static Font font() {
        return ClientUtils.mc().f_91062_;
    }

    public static float partialTicks() {
        return ClientUtils.mc().m_91296_();
    }

    public static BufferedImage readBufferedImage(InputStream imageStream) throws IOException {
        BufferedImage bufferedimage;
        try {
            bufferedimage = ImageIO.read(imageStream);
        }
        finally {
            IOUtils.closeQuietly((Closeable)imageStream);
        }
        return bufferedimage;
    }

    public static Font unicodeFontRender() {
        if (unicodeRenderer == null) {
            unicodeRenderer = new Font(rl -> {
                FontManager resourceManager = ((MinecraftAccess)Minecraft.m_91087_()).getFontManager();
                Map<ResourceLocation, FontSet> fonts = ((FontResourceManagerAccess)resourceManager).getFontSets();
                return fonts.get(Minecraft.f_91058_);
            });
        }
        return unicodeRenderer;
    }

    public static int getDarkenedTextColour(int colour) {
        int r = (colour >> 16 & 0xFF) / 4;
        int g = (colour >> 8 & 0xFF) / 4;
        int b = (colour & 0xFF) / 4;
        return r << 16 | g << 8 | b;
    }

    public static IEBlockEntitySound generatePositionedIESound(SoundEvent soundEvent, float volume, float pitch, boolean repeat, int delay, BlockPos pos) {
        IEBlockEntitySound sound = new IEBlockEntitySound(soundEvent, volume, pitch, repeat, delay, pos, SoundInstance.Attenuation.LINEAR, SoundSource.BLOCKS);
        sound.evaluateVolume();
        ClientUtils.mc().m_91106_().m_120367_((SoundInstance)sound);
        return sound;
    }

    public static Quaternion degreeToQuaterion(double x, double y, double z) {
        x = Math.toRadians(x);
        y = Math.toRadians(y);
        z = Math.toRadians(z);
        Quaternion qYaw = new Quaternion(0.0f, (float)Math.sin(y / 2.0), 0.0f, (float)Math.cos(y / 2.0));
        Quaternion qPitch = new Quaternion((float)Math.sin(x / 2.0), 0.0f, 0.0f, (float)Math.cos(x / 2.0));
        Quaternion qRoll = new Quaternion(0.0f, 0.0f, (float)Math.sin(z / 2.0), (float)Math.cos(z / 2.0));
        qYaw.m_80148_(qRoll);
        qYaw.m_80148_(qPitch);
        return qYaw;
    }

    public static Vec3[] applyMatrixToVertices(Transformation matrix, Vec3 ... vertices) {
        if (matrix == null) {
            return vertices;
        }
        Vec3[] ret = new Vec3[vertices.length];
        for (int i = 0; i < ret.length; ++i) {
            Vector4f vec = new Vector4f((float)vertices[i].f_82479_, (float)vertices[i].f_82480_, (float)vertices[i].f_82481_, 1.0f);
            matrix.transformPosition(vec);
            vec.m_123621_();
            ret[i] = new Vec3((double)vec.m_123601_(), (double)vec.m_123615_(), (double)vec.m_123616_());
        }
        return ret;
    }

    public static Vector4f pulseRGBAlpha(Vector4f rgba, int tickrate, float min, float max) {
        float f_alpha = (float)(ClientUtils.mc().f_91074_.f_19797_ % (tickrate * 2)) / (float)tickrate;
        if (f_alpha > 1.0f) {
            f_alpha = 2.0f - f_alpha;
        }
        return new Vector4f(rgba.m_123601_(), rgba.m_123615_(), rgba.m_123616_(), Mth.m_14036_((float)f_alpha, (float)min, (float)max));
    }

    public static int findOffset(VertexFormat vf, VertexFormatElement.Usage u, VertexFormatElement.Type t) {
        int offset = 0;
        for (VertexFormatElement element : vf.m_86023_()) {
            if (element.m_86048_() == u && element.m_86041_() == t) {
                Preconditions.checkState((offset % 4 == 0 ? 1 : 0) != 0);
                return offset / 4;
            }
            offset += element.m_86050_();
        }
        throw new IllegalStateException();
    }

    public static int findTextureOffset(VertexFormat vf) {
        return ClientUtils.findOffset(vf, VertexFormatElement.Usage.UV, VertexFormatElement.Type.FLOAT);
    }

    public static int findPositionOffset(VertexFormat vf) {
        return ClientUtils.findOffset(vf, VertexFormatElement.Usage.POSITION, VertexFormatElement.Type.FLOAT);
    }

    public static Transformation rotateTo(Direction d) {
        return new Transformation(null).blockCornerToCenter().m_121096_(ClientUtils.toModelRotation(d).m_6189_()).blockCenterToCorner();
    }

    public static BlockModelRotation toModelRotation(Direction d) {
        switch (d) {
            case DOWN: {
                return BlockModelRotation.X90_Y0;
            }
            case UP: {
                return BlockModelRotation.X270_Y0;
            }
            case NORTH: {
                return BlockModelRotation.X0_Y0;
            }
            case SOUTH: {
                return BlockModelRotation.X0_Y180;
            }
            case WEST: {
                return BlockModelRotation.X0_Y270;
            }
            case EAST: {
                return BlockModelRotation.X0_Y90;
            }
        }
        throw new IllegalArgumentException(String.valueOf(d));
    }
}

